package jadean.ui.java.wizards;

import jadean.dean.Resource;

import java.io.File;
import java.util.Collection;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.events.MouseAdapter;

import jadean.dean.java.resources.JavaResourceProjectClass;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class EntryPointPage extends WizardPage {
	private Text entryPointTF;
	private Combo foundCB;
	private Composite mainCO;
	private Composite selectFoundCO;
	private Composite selectOtherCO;
	private WizardInput input;
	private Button foundRB;
	private Button manuallyRB;
	private Button browseBT;
	private Label foundLB;
	private Label manuallyLB;

	public EntryPointPage(WizardInput input) {
		super("Entry point");
		setTitle("Entry point");
		setDescription("Please select entry point of the application. You can do it by selecting resource from classes with method main, or manually by choosing file with source code of the entry point.");
		setControl(entryPointTF);
		this.input = input;
	}

	public void createControl(Composite parent) {
		mainCO = new Composite(parent, SWT.NULL);
		mainCO.setLayout(new GridLayout(1, true));
		
		selectFoundCO = new Composite(mainCO, SWT.NULL);
		selectFoundCO.setLayout(new GridLayout(3, false));
		selectFoundCO.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		foundRB = new Button(selectFoundCO, SWT.RADIO);
		foundRB.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				entryPointTF.setEnabled(false);
				browseBT.setEnabled(false);
				manuallyRB.setSelection(false);
				manuallyLB.setEnabled(false);
				foundCB.setEnabled(true);
				foundRB.setSelection(true);
				foundLB.setEnabled(true);
				_setPageComplete();
			}
		});
		
		foundLB = new Label(selectFoundCO, SWT.NONE);
		foundLB.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		foundLB.setText("Select entry point from found resources");

		foundCB = new Combo(selectFoundCO, SWT.READ_ONLY);
		foundCB.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		foundCB.add("<< Select from found resources >>");
		Collection<JavaResourceProjectClass> mainClasses = input.getProject().getClassesWithMainMethod();
		for (Resource r: mainClasses) {
			foundCB.add(r.getName());
		}
		if (mainClasses.size() > 0) {
			foundCB.select(1);		
		}
		else {
			foundCB.select(0);
		}
		_selectFound();
		foundCB.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				_selectFound();
				_setPageComplete();
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				_selectFound();
				_setPageComplete();
			}
		});
		
		selectOtherCO = new Composite(mainCO, SWT.NULL);
		selectOtherCO.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		GridLayout layout = new GridLayout();
		selectOtherCO.setLayout(layout);
		layout.numColumns = 4;
		
		manuallyRB = new Button(selectOtherCO, SWT.RADIO);
		manuallyRB.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				entryPointTF.setEnabled(true);
				browseBT.setEnabled(true);
				manuallyRB.setSelection(true);
				manuallyLB.setEnabled(true);
				foundCB.setEnabled(false);
				foundRB.setSelection(false);
				foundLB.setEnabled(false);
				_setPageComplete();
			}
		});
		
		manuallyLB = new Label(selectOtherCO, SWT.NONE);
		manuallyLB.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		manuallyLB.setText("Select entry point manually");
		
		entryPointTF = new Text(selectOtherCO, SWT.BORDER | SWT.SINGLE);
		entryPointTF.setText("");
		entryPointTF.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		browseBT = new Button(selectOtherCO, SWT.NONE);
		browseBT.setText("Browse...");
		browseBT.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				FileDialog fd = new FileDialog(getShell(), SWT.OPEN);
				fd.setFilterPath(input.getPath());
				fd.setFilterExtensions(new String[] {"*.java"});
				fd.setFilterNames(new String[] {"JAVA file"});
				String s = fd.open();
				if (s != null) {
					entryPointTF.setText(s);
					String entryPoint = input.getProject().extractResourceNameFromFileName(s);
					input.setEntryPoint(entryPoint);
					_setPageComplete();
				}
			}
		});
		
		entryPointTF.setEnabled(false);
		browseBT.setEnabled(false);
		manuallyRB.setSelection(false);
		manuallyLB.setEnabled(false);
		foundCB.setEnabled(true);
		foundRB.setSelection(true);
		foundLB.setEnabled(true);
		
		setControl(mainCO);
		_setPageComplete();
		input.notifyListeners();
	}
	
	private void _setPageComplete() {
		if (manuallyRB.getSelection()) {
			if ("".equals(entryPointTF.getText())) {
				setErrorMessage(null);
				setPageComplete(false);
			}
			else {
				File f = new File(entryPointTF.getText());
				if (f.exists()) {
					setErrorMessage(null);
					setPageComplete(true);
				}
				else {
					setErrorMessage("Resource does not exist!");
					setPageComplete(false);
				}
			}
		}
		else if (foundRB.getSelection()) {
			if (foundCB.getSelectionIndex() > 0) {
				setErrorMessage(null);
				setPageComplete(true);
			}
			else {
				setErrorMessage(null);
				setPageComplete(false);
			}			
		}
	}
	
	private void _selectFound() {
		if (foundCB.getSelectionIndex() > 0) {
			input.setEntryPoint(foundCB.getItem(foundCB.getSelectionIndex()));
		}
	}
	
}
